/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.model;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.marketplace.client.api.UriTemplate;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;

public final class Link {
    private final Option<String> type;
    final Either<UriTemplate, URI> templateOrUri;

    public Link(Either<UriTemplate, URI> templateOrUri, Option<String> type) {
        this.templateOrUri = templateOrUri;
        this.type = type;
    }

    public static Link fromUri(URI uri, Option<String> type) {
        return new Link((Either<UriTemplate, URI>)Either.right((Object)uri), type);
    }

    public static Link fromUriTemplate(UriTemplate ut, Option<String> type) {
        return new Link((Either<UriTemplate, URI>)Either.left((Object)ut), type);
    }

    public URI getUri() {
        return (URI)this.templateOrUri.fold((Function)new Function<UriTemplate, URI>(){

            public URI apply(UriTemplate t) {
                return t.resolve((Map<String, String>)ImmutableMap.of());
            }
        }, Functions.identity());
    }

    public Option<UriTemplate> getUriTemplate() {
        return this.templateOrUri.left().toOption();
    }

    public Either<UriTemplate, URI> getTemplateOrUri() {
        return this.templateOrUri;
    }

    public Option<String> getType() {
        return this.type;
    }

    public boolean matchType(Option<String> desiredType) {
        Iterator i$ = desiredType.iterator();
        if (i$.hasNext()) {
            String dt = (String)i$.next();
            return this.type == null ? dt.equals("application/json") : dt.equals(this.type);
        }
        return true;
    }

    public String stringValue() {
        Iterator i$ = this.getUriTemplate().iterator();
        if (i$.hasNext()) {
            UriTemplate ut = (UriTemplate)i$.next();
            return ut.getValue();
        }
        return this.getUri().toASCIIString();
    }

    public boolean equals(Object other) {
        if (other instanceof Link) {
            Link o = (Link)other;
            return this.templateOrUri.equals(o.templateOrUri) && ObjectUtils.equals(this.type, o.type);
        }
        return false;
    }

    public int hashCode() {
        return this.templateOrUri.hashCode() + (this.type == null ? 0 : this.type.hashCode());
    }
}

