/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import java.util.Iterator;

public final class ProductVersionSpecifier {
    private final Option<Either<Integer, String>> nameOrBuild;

    private ProductVersionSpecifier(Option<Either<Integer, String>> nameOrBuild) {
        this.nameOrBuild = nameOrBuild;
    }

    public static ProductVersionSpecifier buildNumber(int buildNumber) {
        return new ProductVersionSpecifier((Option<Either<Integer, String>>)Option.some((Object)Either.left((Object)buildNumber)));
    }

    public static ProductVersionSpecifier name(String name) {
        return new ProductVersionSpecifier((Option<Either<Integer, String>>)Option.some((Object)Either.right((Object)name)));
    }

    public static ProductVersionSpecifier latest() {
        return new ProductVersionSpecifier((Option<Either<Integer, String>>)Option.none());
    }

    public Option<Integer> getBuildNumber() {
        Iterator i$ = this.nameOrBuild.iterator();
        if (i$.hasNext()) {
            Either nb = (Either)i$.next();
            return nb.left().toOption();
        }
        return Option.none();
    }

    public Option<String> getName() {
        Iterator i$ = this.nameOrBuild.iterator();
        if (i$.hasNext()) {
            Either nb = (Either)i$.next();
            return nb.right().toOption();
        }
        return Option.none();
    }

    public String toString() {
        Iterator i$ = this.getBuildNumber().iterator();
        if (i$.hasNext()) {
            Integer b = (Integer)i$.next();
            return "buildNumber(" + b + ")";
        }
        i$ = this.getName().iterator();
        if (i$.hasNext()) {
            String n = (String)i$.next();
            return "name(" + n + ")";
        }
        return "latest";
    }

    public boolean equals(Object other) {
        return other instanceof ProductVersionSpecifier && ((ProductVersionSpecifier)other).nameOrBuild.equals(this.nameOrBuild);
    }

    public int hashCode() {
        return this.nameOrBuild.hashCode();
    }
}

