/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.marketplace.client.api;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import java.util.Iterator;

public final class AddonVersionSpecifier {
    private final Option<Either<String, Long>> nameOrBuild;

    private AddonVersionSpecifier(Option<Either<String, Long>> nameOrBuild) {
        this.nameOrBuild = nameOrBuild;
    }

    public static AddonVersionSpecifier buildNumber(long buildNumber) {
        return new AddonVersionSpecifier((Option<Either<String, Long>>)Option.some((Object)Either.right((Object)buildNumber)));
    }

    public static AddonVersionSpecifier versionName(String name) {
        return new AddonVersionSpecifier((Option<Either<String, Long>>)Option.some((Object)Either.left((Object)name)));
    }

    public static AddonVersionSpecifier latest() {
        return new AddonVersionSpecifier((Option<Either<String, Long>>)Option.none());
    }

    public Option<Either<String, Long>> getSpecifiedVersion() {
        return this.nameOrBuild;
    }

    public String toString() {
        for (Either vob : this.nameOrBuild) {
            Iterator i$ = vob.right().iterator();
            if (i$.hasNext()) {
                Long b = (Long)i$.next();
                return "buildNumber(" + b + ")";
            }
            i$ = vob.left().iterator();
            if (!i$.hasNext()) continue;
            String n = (String)i$.next();
            return "name(" + n + ")";
        }
        return "latest";
    }

    public boolean equals(Object other) {
        return other instanceof AddonVersionSpecifier && ((AddonVersionSpecifier)other).nameOrBuild.equals(this.nameOrBuild);
    }

    public int hashCode() {
        return this.nameOrBuild.hashCode();
    }
}

