/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.usercompatibility;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.usercompatibility.ApplicationUserUtilAccessException;
import com.atlassian.jira.usercompatibility.DelegatingApplicationUser;
import com.atlassian.jira.usercompatibility.DelegatingApplicationUsers;
import com.atlassian.jira.usercompatibility.DelegatingUserWithKey;
import com.atlassian.jira.usercompatibility.UserWithKey;
import com.atlassian.jira.util.BuildUtilsInfo;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collection;

public class UserCompatibilityHelper {
    private static final int JIRA_BUILD_NUMBER_6_0_MINIMUM_WITH_BREAKIT = 6040;
    public static final Function<User, Object> convertUserToObjectApplicableForCF = new Function<User, Object>(){

        public Object apply(User user) {
            return UserCompatibilityHelper.getUserObjectApplicableForUserCF(user);
        }
    };

    public static UserWithKey convertUserObject(Object userObject) {
        if (userObject == null) {
            return null;
        }
        if (userObject instanceof User) {
            User user = (User)userObject;
            return new DelegatingUserWithKey(user, UserCompatibilityHelper.getKeyForUser(user));
        }
        if (!UserCompatibilityHelper.isRenameUserImplemented()) {
            throw new IllegalArgumentException("Unknown class representing user: " + userObject.getClass().getName());
        }
        DelegatingApplicationUser appUser = new DelegatingApplicationUser(userObject);
        return new DelegatingUserWithKey(appUser.getDirectoryUser(), appUser.getKey());
    }

    public static String getKeyForUser(User user) {
        if (user == null) {
            return null;
        }
        if (UserCompatibilityHelper.isRenameUserImplemented()) {
            return DelegatingApplicationUsers.getKeyFor(user);
        }
        return IdentifierUtils.toLowerCase((String)user.getName());
    }

    public static Object getUserObjectApplicableForUserCF(User user) {
        if (user == null) {
            return null;
        }
        if (!UserCompatibilityHelper.isRenameUserImplemented()) {
            return user;
        }
        return DelegatingApplicationUsers.from(user);
    }

    public static Collection<Object> getUserObjectsApplicableForMultiUserCF(Iterable<User> users) {
        if (users == null) {
            return null;
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform(users, convertUserToObjectApplicableForCF));
    }

    public static User getUserForKey(String key) {
        if (key == null) {
            return null;
        }
        if (UserCompatibilityHelper.isRenameUserImplemented()) {
            Object applicationUserObject = DelegatingApplicationUsers.byKey(key);
            if (applicationUserObject == null) {
                return null;
            }
            DelegatingApplicationUser appUser = new DelegatingApplicationUser(applicationUserObject);
            return appUser.getDirectoryUser();
        }
        return ComponentAccessor.getUserManager().getUserObject(key);
    }

    public static boolean isUserObject(Object object) {
        try {
            return object instanceof User || UserCompatibilityHelper.isRenameUserImplemented() && DelegatingApplicationUser.getAppUserClass().isInstance(object);
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    private static boolean isRenameUserImplemented() {
        BuildUtilsInfo buildUtilsInfo = (BuildUtilsInfo)ComponentAccessor.getComponent(BuildUtilsInfo.class);
        return buildUtilsInfo.getApplicationBuildNumber() >= 6040;
    }
}

