/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.usercompatibility;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.usercompatibility.ApplicationUserUtilAccessException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class DelegatingApplicationUsers {
    DelegatingApplicationUsers() {
    }

    static String getKeyFor(User user) {
        try {
            Class<?> appUsersClass = DelegatingApplicationUsers.getApplicationUsersClass();
            Method getAppUserKeyMethod = appUsersClass.getMethod("getKeyFor", User.class);
            return (String)getAppUserKeyMethod.invoke(null, user);
        }
        catch (NoSuchMethodException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    static Object byKey(String key) {
        try {
            Class<?> appUsersClass = DelegatingApplicationUsers.getApplicationUsersClass();
            Method byKeyMethod = appUsersClass.getMethod("byKey", String.class);
            return byKeyMethod.invoke(null, key);
        }
        catch (NoSuchMethodException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    static Object from(User user) {
        try {
            Class<?> appUsersClass = DelegatingApplicationUsers.getApplicationUsersClass();
            Method fromMethod = appUsersClass.getMethod("from", User.class);
            return fromMethod.invoke(null, user);
        }
        catch (NoSuchMethodException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    private static Class<?> getApplicationUsersClass() {
        try {
            return Class.forName("com.atlassian.jira.user.ApplicationUsers");
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }
}

