/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.usercompatibility;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.usercompatibility.ApplicationUserUtilAccessException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class DelegatingApplicationUser {
    private final Object applicationUser;
    private final Class<?> appUsersClass;

    DelegatingApplicationUser(Object applicationUser) {
        try {
            this.appUsersClass = DelegatingApplicationUser.getAppUserClass();
            if (!this.appUsersClass.isAssignableFrom(applicationUser.getClass())) {
                throw new IllegalArgumentException("Unknown class representing user: " + applicationUser.getClass().getName());
            }
            this.applicationUser = applicationUser;
        }
        catch (ClassNotFoundException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    String getKey() {
        try {
            Method getKeyMethod = this.appUsersClass.getMethod("getKey", new Class[0]);
            return (String)getKeyMethod.invoke(this.applicationUser, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    User getDirectoryUser() {
        try {
            Method getKeyMethod = this.appUsersClass.getMethod("getDirectoryUser", new Class[0]);
            return (User)getKeyMethod.invoke(this.applicationUser, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (IllegalAccessException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
        catch (InvocationTargetException e) {
            throw new ApplicationUserUtilAccessException(e);
        }
    }

    static Class<?> getAppUserClass() throws ClassNotFoundException {
        return Class.forName("com.atlassian.jira.user.ApplicationUser");
    }
}

