/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.cache.compat.guava10.memory;

import com.atlassian.cache.compat.Cache;
import com.atlassian.cache.compat.CacheLoader;
import com.atlassian.cache.compat.CacheSettings;
import com.atlassian.cache.compat.CacheSettingsBuilder;
import com.atlassian.cache.compat.CachedReference;
import com.atlassian.cache.compat.GuavaAwareCacheFactory;
import com.atlassian.cache.compat.Supplier;
import com.atlassian.cache.compat.guava10.memory.MemoryCache;
import com.atlassian.cache.compat.guava10.memory.MemoryCachedReference;
import com.atlassian.cache.compat.impl.AbstractCacheFactory;
import com.atlassian.cache.compat.impl.ReferenceKey;
import com.atlassian.cache.compat.impl.StrongSupplier;
import com.atlassian.cache.compat.impl.WeakSupplier;
import com.atlassian.util.concurrent.ManagedLock;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class MemoryCacheFactory
extends AbstractCacheFactory
implements GuavaAwareCacheFactory {
    @Override
    public <V> CachedReference<V> getCachedReference(String name, final Supplier<V> supplier, CacheSettings settings) {
        final CacheSettings overriddenSettings = settings.override(new CacheSettingsBuilder().flushable().maxEntries(1).build());
        return (CachedReference)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock(new com.atlassian.util.concurrent.Supplier<MemoryCachedReference<V>>(){

            public MemoryCachedReference<V> get() {
                ConcurrentMap computingCache = MemoryCacheFactory.this.createMapMaker(overriddenSettings).makeComputingMap(new Function<ReferenceKey, V>(){

                    public V apply(@Nullable ReferenceKey key) {
                        return supplier.get();
                    }
                });
                return MemoryCachedReference.create(computingCache);
            }
        });
    }

    @Override
    public Cache createSimpleCache(final String name, final CacheSettings settings) {
        Cache cache;
        Supplier cacheSupplier = (Supplier)this.caches.get(name);
        if (cacheSupplier != null && (cache = (Cache)cacheSupplier.get()) != null) {
            return cache;
        }
        return (Cache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock((com.atlassian.util.concurrent.Supplier)new com.atlassian.util.concurrent.Supplier<Cache>(){

            public Cache get() {
                if (!MemoryCacheFactory.this.caches.containsKey(name)) {
                    ConcurrentMap simpleCache = MemoryCacheFactory.this.createMapMaker(settings).makeMap();
                    MemoryCache cache = MemoryCache.create(simpleCache, name, settings);
                    MemoryCacheFactory.this.caches.put(name, new StrongSupplier(cache));
                }
                return (Cache)((Supplier)MemoryCacheFactory.this.caches.get(name)).get();
            }
        });
    }

    @Override
    public <K, V> Cache createComputingCache(final String name, final CacheSettings settings, final CacheLoader<K, V> loader) {
        return (Cache)((ManagedLock)this.cacheCreationLocks.get((Object)name)).withLock(new com.atlassian.util.concurrent.Supplier<MemoryCache<K, V>>(){

            public MemoryCache<K, V> get() {
                ConcurrentMap computingCache = MemoryCacheFactory.this.createMapMaker(settings).makeComputingMap(new Function<K, V>(){

                    public V apply(@Nullable K key) {
                        return loader.load(key);
                    }
                });
                MemoryCache cache = MemoryCache.create(computingCache, name, settings);
                if (!MemoryCacheFactory.this.caches.containsKey(name)) {
                    MemoryCacheFactory.this.caches.put(name, new WeakSupplier(cache));
                }
                return cache;
            }
        });
    }

    private MapMaker createMapMaker(CacheSettings settings) {
        MapMaker mapMaker = new MapMaker();
        if (null != settings.getMaxEntries()) {
            mapMaker.maximumSize(settings.getMaxEntries().intValue());
        }
        if (null != settings.getExpireAfterAccess()) {
            mapMaker.expireAfterAccess(settings.getExpireAfterAccess().longValue(), TimeUnit.MILLISECONDS);
        } else if (null != settings.getExpireAfterWrite()) {
            mapMaker.expireAfterWrite(settings.getExpireAfterWrite().longValue(), TimeUnit.MILLISECONDS);
        }
        return mapMaker;
    }
}

